package agentes;

import ontologias.frutasOntology.*;

import java.io.StringReader;
import java.io.OutputStreamWriter;
import java.io.BufferedWriter;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.IOException;
import java.io.PrintWriter;

import jade.core.*;
import jade.core.behaviours.*;
import jade.lang.acl.*;
import jade.domain.FIPAAgentManagement.ServiceDescription;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.DFService;
import jade.domain.FIPAException;
 
import jade.content.*;
import jade.content.lang.*;
import jade.content.lang.sl.*;
import jade.content.onto.*;
 
 
public class Vendedor extends Agent {
 
    private Codec codec = new SLCodec();
    private Ontology ontologia = frutasOntology.getInstance();
    private int comportamiento=0;
    protected void setup() {
    	 
        /** Registrarse en el DF */
        DFAgentDescription dfd = new DFAgentDescription();
        ServiceDescription sd = new ServiceDescription();
        sd.setType("Vendedor");
        sd.setName(getName());
        sd.setOwnership("US");
        dfd.setName(getAID());
        dfd.addServices(sd);
        try {
        DFService.register(this,dfd);
        } catch (FIPAException e) {
            System.err.println("AV: "+getLocalName()+" no se pudo completar el registro en el DF. Razon: "+e.getMessage());
            doDelete();
        }
        
        //Registramos codec y ontologia 
        getContentManager().registerLanguage(codec);
        getContentManager().registerOntology(ontologia);
        
        //Aadimos comportamiento de respuesta
        EnviarMensajeBehaviour EnviarBehaviour = new EnviarMensajeBehaviour(this);
        addBehaviour(EnviarBehaviour);
        }
 
    class EnviarMensajeBehaviour extends SimpleBehaviour {
 
      private boolean finished = false;
 
    public EnviarMensajeBehaviour(Agent a) {
        super(a);
    }
 
    public void action() {
        try
    {
        	if(comportamiento==0)
        	{
        	System.out.println("\nAV: Introduce el nombre del DESTINATARIO (el nombre dado al Agente Comprador al lanzar la plataforma): ");
            BufferedReader buff = new BufferedReader(new InputStreamReader(System.in));
            String respuesta = buff.readLine();
            
            //Creamos el mensaje a enviar
            AID r = new AID();
            r.setLocalName(respuesta);
            ACLMessage msg = new ACLMessage(ACLMessage.INFORM);
            msg.setSender(getAID());
            msg.addReceiver(r);
            msg.setLanguage(codec.getName());
            msg.setOntology(ontologia.getName());
            
            //Introducimos el nombre de la fruta a vender
            System.out.println("\nAV: Introduce el NOMBRE de la fruta:");
            respuesta = buff.readLine();
            Fruta fru = new Fruta();
            fru.setNombre(respuesta);
            
            //Introducimos el precio
            System.out.println("\nAV: Introduce el PRECIO:");
            respuesta = buff.readLine();
            fru.setPrecio(Integer.parseInt(respuesta));
            
            //Creamos predicado "Oferta" para comunicar la oferta realizada (el concepto FRUTA)
            Oferta of = new Oferta();
            of.setFruta(fru);
            
            //Preparamos el mensaje finalmente para enviarlo
            getContentManager().fillContent(msg, of); //Rellenamos el slot de contenido del mensaje ACL con el predicado creado
            send(msg);
        	}

	            //Esperamos respuesta
	            comportamiento++;
	            MessageTemplate mt = MessageTemplate.and(
	            MessageTemplate.MatchLanguage(codec.getName()),
	            MessageTemplate.MatchOntology(ontologia.getName()));
	            ACLMessage  msg2 = blockingReceive(mt);
	            System.out.println("\nAV: Recibida respuesta del Comprador....");

	          
         
                if(msg2 != null){
                	if(msg2.getPerformative() == ACLMessage.NOT_UNDERSTOOD){
                		System.out.println("AV: Mensaje NOT UNDERSTOOD recibido");
                    }
                	else{
	 
                		if(msg2.getPerformative()== ACLMessage.REQUEST){
	                    	//Esta de acuerdo en la compra
	                        System.out.println("AV:Gracias por su compra!");
	                        comportamiento=0;                    
	                    }
	                    else if(msg2.getPerformative()== ACLMessage.DISCONFIRM){
	                        //Rechaza la compra
	                    	 System.out.println("AV:Lo siento!");
	                    	 comportamiento=0; 
	                    }
	                    else if(msg2.getPerformative()== ACLMessage.PROPOSE){
	                    	//Desea negociar precio
	                    	//Tomamos decision
	                        System.out.println("Pensando como negocio... ");
	                        drools.motorDrools motorInferencia = new drools.motorDrools();
	                        
	                        //Determino el humor en el que se encuentra el vendedor y lo asocio
	                        ContentElement ce = getContentManager().extractContent(msg2);
	                        if (ce instanceof Oferta){
	                            // Recibido un INFORM con contenido correcto
	                            Oferta newof = (Oferta) ce;
	                            Fruta newfru = newof.getFruta();
	                            newfru.setAgente(myAgent); //Asociamos el agente a la fruta
	                            newfru.setMensaje(msg2);//Asociamos el mensaje a la fruta
		                        if(Math.random()>0.5)
		                        	newfru.setHumorComprador("buenas");
		                        else
		                        	newfru.setHumorComprador("malas");
		                      //Insertamos los hechos	                        
		                        motorInferencia.insertarHecho(newfru, 1); 
	                        }else{
	                        	System.out.println("Fallo el predicado");
	                        }
	                        
	                       
	                    }
	                    else{System.out.println("AV: Mensaje No gestionado");}
	                }
                }else{
                  System.out.println("No message received");
                }
	            

 
    	}
           catch (java.io.IOException io)
            {System.out.println(io);
        }
        catch (jade.content.lang.Codec.CodecException ce) {
               System.out.println(ce);
        }
        catch (jade.content.onto.OntologyException oe) {
            System.out.println(oe);
        }
    catch (Exception e){
        System.out.println("\n\nAV: ... Terminando ...");
        finished=true;
    }
    }
 
    public boolean done() {
 
     return finished;
 
    }
    } // Fin de la clase EnviarMensajeBehaviour
 

 
   protected void takeDown() {
        try {
            DFService.deregister(this);
        }
        catch (FIPAException fe) {
            fe.printStackTrace();
        }
    }
}

